# pomocná funkcia
def vypis(g):
    for riadok in g:
        print(*riadok)


# a) Pozná sa každý s každým?
def kazdy_s_kazdym(g):
    for u in range(len(g)):
        # súčet hodnôt v riadku môžeme získať aj pomocou funkcie sum()
        s = sum(g[u])
        if s != n - 1:
            return False
    return True


# b) Existuje osoba, ktorú nikto nepozná a ani ona nikoho nepozná?
def cudzinec(g):
    for u in range(len(g)):
        s = sum(g[u])
        if s == 0:
            for v in range(len(g)):
                s += g[v][u]
            if s == 0:
                return True
    return False


# c) Koľko párov osôb sa pozná navzájom? (dajte pozor, aby sme ten istý pár poznajúcich sa osôb nezapočítali dvakrát!)
def pocet_znamych(g):
    kolko = 0
    for u in range(1, len(g)):
        # v každom riadku kontrolujeme iba prvky pod hlavnou diagonálou
        for v in range(u):
            if g[u][v] == 1 and g[v][u] == 1:
                kolko += 1
    return kolko


# d) Ktorá z osôb má najviac priateľov (za priateľov považujeme takú dvojicu osôb, ktoré sa poznajú navzájom).
def najviac_priatelov(g):
    osoba = max = -1
    for u in range(len(g)):
        pocet = 0
        for v in range(len(g)):
           if g[u][v] == 1 and g[v][u] == 1:
                pocet += 1
        if pocet > max:
            max = pocet
            osoba = u
    return osoba, max


# hlavný program
# spracovanie vstupného súboru
with open('vstup.txt') as f:
    # prečítame počet vrcholov
    n = int(f.readline())
    # pripravíme maticu typu n x n
    g = [[0] * n for i in range(n)]
    # prečítame a uložíme informáciu o hranách
    for riadok in f:
        hrana = riadok.split()
        u = int(hrana[0])
        v = int(hrana[1])
        g[u][v] = 1

# obsah matice vypíšeme na obrazovku
vypis(g)
# výpis výsledkov jednotlivých funkcií
print(kazdy_s_kazdym(g))
print(cudzinec(g))
print(pocet_znamych(g))
print(najviac_priatelov(g))
